//
//  NASDiscovery.h
//  StatusMenu
//
//  Created by Bob Hahn on 7/14/10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Foundation/NSNetServices.h>

#define urlRequestTimeout 30

//*************************************************************************
//  @protocol NASDiscoveryDelegate
//*************************************************************************
@protocol NASDiscoveryDelegate

@optional
-(void)serviceDidUpdate;

@end // NASDiscoveryDelegate

@interface NASDiscovery : NSObject
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_6
<NSNetServiceBrowserDelegate>
#endif
{
	NSNetServiceBrowser *serviceBrowser;
	NSNetService		*service;
	int					resolveCount;
	NSMutableDictionary	*nasDevices;
	NSMutableArray		*resolveQueue;
	id                  delegate;
    BOOL                delegateRespondsToServiceDidUpdate;
	NSTimer				*updateServiceInformationTimer;
//	NSLock				*ServiceInformationLock;
	NSLock				*nasDevicesLock;
	BOOL				foundWDNasDevice;
	NSDictionary*		PreviousDictionary;
    NSArray*            modelsOfInterest;
}
//- (id) init;
//- (void) startServerBrowserControllerThread;

@property (readwrite, retain) NSArray* modelsOfInterest;
@property (readwrite, retain) NSNetServiceBrowser* serviceBrowser;

- (id) initWithModels:(NSArray*) theModelsOfInterest delegate:(id) theDelegate; // designated initializer


- (NSDictionary*) nasDevicesDictionary;
- (NSError *) systemInformationForNasDevice: (NSMutableDictionary *) deviceName;
- (NSError *) firmwareInfoForNasDevice: (NSMutableDictionary *) deviceName;
- (NSError *) storageUsageForNasDevice: (NSMutableDictionary *) deviceName;
- (NSError *) systemStateForNasDevice: (NSMutableDictionary *) deviceName;
- (NSError *) firmwareUpdateStatusForNasDevice: (NSMutableDictionary *) deviceName;

+ (NSDictionary*) dictionaryFromXMLNode: (NSXMLNode *)rootNode;

- (void) setDelegate: (id<NASDiscoveryDelegate>) object;
- (void) updateServiceInformation;

@end
